/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#ifndef __SHAWN_LEGACYAPPS_WS08_PROCESSOR_H
#define __SHAWN_LEGACYAPPS_WS08_PROCESSOR_H
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08

#include <map>
#include <limits>
#include "sys/processor.h"
#include "sys/event_scheduler.h"
#include "legacyapps/ws08/ws08_message.h"
#include "apps/reading/simple_reading.h"

namespace ws08
{

   /**
    */
   class Ws08Processor
       : public shawn::Processor, 
         public shawn::EventScheduler::EventHandler
   {
   public:
      ///@name Constructor/Destructor
      ///@{
      Ws08Processor();
      virtual ~Ws08Processor();
      ///@}

      ///@name Inherited from Processor
      ///@{
      /**
       */
      virtual void special_boot( void ) throw();
      /**
       */
      virtual void boot( void ) throw();\
      /**
       */
      virtual bool process_message( const shawn::ConstMessageHandle& ) throw();
      /**
       */
      virtual void work( void ) throw();
      ///@}
      
      ///@name Inherited from EventScheduler::EventHandler
      ///@{
      /**
       */
      virtual void timeout( shawn::EventScheduler&, 
                            shawn::EventScheduler::EventHandle, 
                            double, 
                            shawn::EventScheduler::EventTagHandle& ) throw();
      ///@}

   private:
      ///@name Message Handling
      ///@{
      /**
       */
      void handle_flooding_message_node( const Ws08FloodingMessage& flooding ) throw();
      /**
       */
      void handle_temperature_message_node( const Ws08RouteTemperatureMessage& state ) throw();
      /**
       */
      void handle_temperature_message_gate( const Ws08RouteTemperatureMessage& state ) throw();
      /**
       */
      void handle_local_temperature_message_node( const Ws08LocalTemperatureMessage& tempmsg ) throw();
      ///@}
      
      ///@name Sensor and Reading
      ///@{
      /**
       */
      void start_temperature_matching( void ) throw();
      /**
       */
      void init_sensor( void ) throw();
      /**
       */
      double sensor_value( void ) throw();
      ///@}
      
      // --------------------------------------------------------------------
      
      typedef std::map<const shawn::Node*, double> temperature_map;
      typedef temperature_map::iterator temperature_map_iterator;
      typedef temperature_map::const_iterator const_temperature_map_iterator;
      
      // --------------------------------------------------------------------
      
      /// defines whether a node is connected to the routing tree (and thus
      /// knows a valid predecessor)
      bool connected_;
      /// just set to true when 'special node' 
      bool gateway_;
      /// current hop distance to sink
      int hop_dist_;
      /** Used by ordinary nodes to send actual values like temperature or 
       *  hop_count. Set parameter \c state_period. 
       * 
       *  On gate, it defines the refreshing interval for flooding the 
       *  network. Set parameter \c flood_period.
       */
      int send_period_;
      /// Used for routing messages to sink. They are always sent/forwarded
      /// to the predecessor (if not null)
      const shawn::Node* predecessor_;
      /// If the number of identified outliers is greater than this limit, the
      /// assumes itself is an outlier
      double max_outlier_frac_;
      /// Defines the limit when a node is assumed to be an outlier
      double outlier_difference_;
      /// Temperatures of neighboring nodes
      temperature_map temperatures_;
      /// Storing return value when registering an event
      shawn::EventScheduler::EventHandle event_handle_;
      ///
      reading::DoubleReadingHandle temperature_reading_;
      /// if malfunctioned, sensor returns false values
      bool sensor_malfunction_;
      
      // --------------------------------------------------------------------
      
      static const int UNKNOWN_DIST;
   };


}

#endif
#endif
