/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08

#include "legacyapps/ws08/ws08_routing_tag_task.h"
#include "sys/taggings/basic_tags.h"
#include "sys/world.h"
#include <deque>

using namespace shawn;

namespace ws08
{

   // ----------------------------------------------------------------------
   Ws08RoutingTagTask::Ws08RoutingTagTask()
   {
   }
   // ----------------------------------------------------------------------
   Ws08RoutingTagTask::~Ws08RoutingTagTask()
   {
   }
   // ----------------------------------------------------------------------
   void Ws08RoutingTagTask::run( SimulationController& sc )
   throw( std::runtime_error )
   {
      // adds Tags named "predecessor" and "hop_count" to each node

      std::deque<Node*> connected_nodes;

      for ( World::node_iterator
            n_it = sc.world_w().begin_nodes_w();
            n_it != sc.world_w().end_nodes_w();
            n_it++ )
      {
         IntegerTag* intt;
         // special node gets special values
         if ( (*n_it).is_special_node() )
         {
            (*n_it).write_simple_tag<std::string>( "predecessor", "--");
            (*n_it).write_simple_tag<std::string>( "gateway", "true" );
            (*n_it).write_simple_tag<int>( "hop_count", 0);
            connected_nodes.push_back(&(*n_it));
         } else
         // the other nodes are initialized with -1, meaning no valid predecessor
         // and hop_count available
         {
            (*n_it).write_simple_tag<std::string>( "predecessor", "-");
            (*n_it).write_simple_tag<int>( "hop_count", -1);
         }
      }

      while (!connected_nodes.empty())
      {
         // take a current node from the queue and get its id()
         Node* current_node = connected_nodes.front();

         //read the current nodes label
         std::string node_label = (*current_node).label();

         // read the current nodes hop count
         int hop_count = (*current_node).read_simple_tag<int>( "hop_count" );

         // iterate over the current nodes neighbors, if they have no predecessor
         // yet (predecessor="-") store the current nodes label and its hop count
         // incremented by 1 in their Tags. Add the nodes to the connected_nodes queue

         for ( EdgeModel::adjacency_iterator
               a_it = sc.world_w().begin_adjacent_nodes_w( *current_node );
               a_it != sc.world_w().end_adjacent_nodes_w( *current_node );
               ++a_it )

         {
            std::string predecessor;
            predecessor = (*a_it).read_simple_tag<std::string>( "predecessor" );
            if ( predecessor == "-")
            {
               (*a_it).write_simple_tag<std::string>( "predecessor", node_label);
               (*a_it).write_simple_tag<int>( "hop_count", hop_count + 1);
               connected_nodes.push_back(&(*a_it));
            }
         }
         connected_nodes.pop_front();
      }
   }
   // ----------------------------------------------------------------------
   std::string Ws08RoutingTagTask::name(void) const throw()
   {
      return "ws08-shortestpath";
   }
   // ----------------------------------------------------------------------
   std::string Ws08RoutingTagTask::description(void) const throw()
   {
      return "attaches a tag to the nodes and writes routing information into it";
   }
}

#endif
