/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#ifndef __SHAWN_LEGACYAPPS_WS08_PROCESSOR_H
#define __SHAWN_LEGACYAPPS_WS08_PROCESSOR_H
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08

#include <map>
#include <limits>
#include "sys/processor.h"
#include "sys/event_scheduler.h"
#include "legacyapps/ws08/ws08_message.h"

namespace ws08
{

   /**
    */
   class Ws08Processor
       : public shawn::Processor, 
         public shawn::EventScheduler::EventHandler
   {
   public:
      ///@name Constructor/Destructor
      ///@{
      Ws08Processor();
      virtual ~Ws08Processor();
      ///@}

      ///@name Inherited from Processor
      ///@{
      /**
       */
      virtual void special_boot( void ) throw();
      /**
       */
      virtual void boot( void ) throw();\
      /**
       */
      virtual bool process_message( const shawn::ConstMessageHandle& ) throw();
      /**
       */
      virtual void work( void ) throw();
      ///@}
      
      ///@name Inherited from EventScheduler::EventHandler
      ///@{
      /**
       */
      virtual void timeout( shawn::EventScheduler&, 
                            shawn::EventScheduler::EventHandle, 
                            double, 
                            shawn::EventScheduler::EventTagHandle& ) throw();
      ///@}

   private:
      ///@name Message Handling
      ///@{
      /**
       */
      void handle_flooding_message_node( const Ws08FloodingMessage& flooding ) throw();
      /**
       */
      void handle_state_message_node( const Ws08StateMessage& state ) throw();
      /**
       */
      void handle_state_message_gate( const Ws08StateMessage& state ) throw();
      ///@}
            
      // --------------------------------------------------------------------
      
      /// defines whether a node is connected to the routing tree (and thus
      /// knows a valid predecessor)
      bool connected_;
      /// just set to true when 'special node' 
      bool gateway_;
      /// current hop distance to sink
      int hop_dist_;
      /** Used by ordinary nodes to send actual values like temperature or 
       *  hop_count. Set parameter \c state_period. 
       * 
       *  On gate, it defines the refreshing interval for flooding the 
       *  network. Set parameter \c flood_period.
       */
      int send_period_;
      /// Used for routing messages to sink. They are always sent/forwarded
      /// to the predecessor (if not null)
      const shawn::Node* predecessor_;
      /// Storing at gate: nodes and their hopcount
      std::map<const shawn::Node*, int> network_nodes_;
      /// Storing return value when registering an event
      shawn::EventScheduler::EventHandle event_handle_;
      
      // --------------------------------------------------------------------
      
      static const int UNKNOWN_DIST;
   };


}

#endif
#endif
