/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#ifndef __SHAWN_LEGACYAPPS_WS08_MESSAGE_H
#define __SHAWN_LEGACYAPPS_WS08_MESSAGE_H
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08

#include "sys/message.h"

namespace ws08
{

   class Ws08FloodingMessage
       : public shawn::Message
   {
   public:
      Ws08FloodingMessage( int hops );
      virtual ~Ws08FloodingMessage();
         
      inline int hops( void ) const throw()
      { return hops_; };
         
   private:
      int hops_;
   };
   // ----------------------------------------------------------------------
   // ----------------------------------------------------------------------
   // ----------------------------------------------------------------------
   class Ws08StateMessage
      : public shawn::Message
   {
   public:
      Ws08StateMessage( const shawn::Node& initiator, 
                        const shawn::Node& dest, 
                        int initiator_hops,
                        int msg_source_hops );
      virtual ~Ws08StateMessage();

      inline const shawn::Node& initiator( void ) const throw()
      {  return initiator_; };
      
      inline const shawn::Node& destination( void ) const throw()
      {  return destination_; };
      
      inline int initiator_hops( void ) const throw()
      {  return initiator_hops_; };
      
      inline int msg_source_hops( void ) const throw()
      {  return msg_source_hops_; };

   private:
      const shawn::Node& initiator_;
      const shawn::Node& destination_;
      int initiator_hops_;
      int msg_source_hops_;
   };
       
}

#endif
#endif
