/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08

#include <iostream>
#include "legacyapps/ws08/ws08_init.h"
#include "legacyapps/ws08/ws08_processor_factory.h"
// Uncomment in Session 4
//#include "legacyapps/ws08/ws08_delayed_transmission_model_factory.h"
//#include "legacyapps/ws08/ws08_routing_tag_task.h"
// Uncomment in Session 5
// #include "legacyapps/ws08/ws08_temperature_reading.h"
#include "sys/simulation/simulation_controller.h"
#include "sys/simulation/simulation_task_keeper.h"
#include "sys/transm_models/transmission_model_keeper.h"
#include "apps/reading/reading_keeper.h"


extern "C" void init_ws08( shawn::SimulationController& sc )
{
   USER( "Initialising WinterSchool 2008 module (WS08)" );
   ws08::Ws08ProcessorFactory::register_factory( sc );
   // Uncomment in Session 4
   //sc.transmission_model_keeper_w().add( new ws08::Ws08DelayedTransmissionModelFactory() );
   //sc.simulation_task_keeper_w().add( new ws08::Ws08RoutingTagTask );
   // Uncomment in Session 5
   //sc.reading_keeper_w().add( new ws08::Ws08TemperatureReading );
}

#endif
