// vim: set expandtab sw=3 ts=3:
#ifndef __UTIL_WISEBED_NODE_API_REMOTE_UART_MODEL_H
#define __UTIL_WISEBED_NODE_API_REMOTE_UART_MODEL_H

#include <stdint.h>

#include "util/base_classes/uart_base.h"
#include "util/delegates/delegate.hpp"
#include "util/serialization/simple_types.h"
#include "util/pstl/vector_static.h"
#include "util/pstl/pair.h"
#include "config_testing.h"

#include "command_types.h"
#include "remote_uart_message.h"

namespace wiselib
{
   template<typename OsModel_P,
            typename Radio_P,
            typename Flooding_Radio_P, 
            typename Uart_P,
            typename Debug_P = typename OsModel_P::Debug,
            typename Timer_P = typename OsModel_P::Timer,
            typename Rand_P = typename OsModel_P::Rand>
   class RemoteUartModel
      : public UartBase<OsModel_P,
                        typename Uart_P::size_t,
                        typename Uart_P::block_data_t>
   {
   public:
      typedef OsModel_P OsModel;
      typedef Radio_P Radio;
      typedef Flooding_Radio_P Flooding;
      typedef Uart_P Uart;
      typedef Timer_P Timer;
      typedef Debug_P Debug;
      typedef Rand_P Rand;

      typedef RemoteUartModel<OsModel, Radio, Flooding, Uart, Debug,
                              Timer, Rand> self_t;
      typedef self_t* self_pointer_t;

      typedef typename Radio::node_id_t node_id_t;
      typedef typename Uart::size_t size_t;
      typedef typename Uart::block_data_t block_data_t;
      typedef typename Radio::size_t radio_size_t;
      typedef typename Radio::block_data_t radio_block_data_t;
      typedef RemoteUartInMessage<OsModel, Radio> Message;

      enum ReturnValues {
         SUCCESS = OsModel::SUCCESS,
         ERR_UNSPEC = OsModel::ERR_UNSPEC
      };

      RemoteUartModel()
        : radio_(0),
            flooding_(0),
            uart_(0),
            debug_(0),
            timer_(0),
            random_(0)
      {}

      void init( Radio& radio, Flooding& flooding_radio, Uart& uart,
                 Debug& debug, Timer& timer, Rand& random )
      {
         radio_ = &radio;
         uart_ = &uart;
         debug_ = &debug;
         timer_ = &timer;
         flooding_ = &flooding_radio;
         random_ = &random;

         /*
         uart_->template reg_read_callback<self_type,  ...  >(this);
         timer_->template set_timer<self_type,  ...  >(  ...  );
         radio_->template reg_recv_callback< ... >( ... );
         flooding_->template reg_recv_callback< ... >( ... );
         */
      }

      int init()
      {
    	  return ERR_UNSPEC;
      }

      int destruct()
      {
    	  return ERR_UNSPEC;
      }

      // From the Serial Communication Concept
      int write( size_t len, block_data_t *buf )
      {
    	  // ...
		eturn ERR_UNSPEC;
      }

      int enable_serial_comm()
      {
    	  // ...
    	  // uart_->enable_serial_comm();
    	  return ERR_UNSPEC;
      }

      int disable_serial_comm()
      {
    	  // ...
    	  return ERR_UNSPEC;
      }

   private:
      Radio& radio() { return *radio_; }
      Flooding& flooding() { return *flooding_; }
      Uart& uart() { return *uart_; }
      Debug& debug() { return *debug_; }

      typename Radio::self_pointer_t radio_;
      typename Flooding::self_pointer_t flooding_;
      typename Uart::self_pointer_t uart_;
      typename Debug::self_pointer_t debug_;
      typename Timer::self_pointer_t timer_;
      typename Rand::self_pointer_t random_;
   };
}

#endif
