#include "external_interface/external_interface.h"
#include "internal_interface/routing_table/routing_table_static_array.h"
#include "algorithms/routing/tree/tree_routing.h"
#include "algorithms/routing/dsdv/dsdv_routing.h"
#include "algorithms/routing/dsr/dsr_routing.h"
#include "algorithms/routing/flooding/flooding_algorithm.h"
#include "algorithms/routing/static/static_routing_algorithm.h"
#include "util/pstl/map_static_vector.h"
#include "util/pstl/map_static_vector.h"

#include "remote_uart.h"

typedef wiselib::OSMODEL Os;
// --------------------------------------------------------------------------
typedef Os::Uart uart_t;

typedef wiselib::MapStaticVector<Os,Os::Radio::node_id_t,uint16_t,64> node_map_t;
typedef wiselib::FloodingAlgorithm<Os, node_map_t> flooding_t;

typedef wiselib::StaticArrayRoutingTable<Os, Os::Radio, 30,
      wiselib::DsdvRoutingTableValue<Os, Os::Radio> > routing_table_t;
typedef wiselib::DsdvRouting<Os, routing_table_t, Os::Radio> routing_t;

typedef wiselib::RemoteUartModel<Os,routing_t,flooding_t,uart_t> remote_uart_t;

class RemoteUartApplication
{
   public:
      void init( Os::AppMainParameter& value )
      {
         radio_ = &wiselib::FacetProvider<Os, Os::Radio>::get_facet( value );
         timer_ = &wiselib::FacetProvider<Os, Os::Timer>::get_facet( value );
         debug_ = &wiselib::FacetProvider<Os, Os::Debug>::get_facet( value );
         uart_ = &wiselib::FacetProvider<Os, uart_t>::get_facet( value );
         random_ = &wiselib::FacetProvider<Os, Os::Rand>::get_facet( value );

         debug_->debug( "INIT RemoteUartApplication over app_main in Wiselib\n" );

         flooding_.init(*radio_,*debug_);
         routing_.init(*radio_,*timer_,*debug_);

         remote_uart_.init(routing_,flooding_,*uart_,*debug_,*timer_,*random_);
         remote_uart_.enable_serial_comm( );

         if ( radio_->id( ) == 0 )
         {
        	 //debug_->debug( "set %d to sink\n",radio_->id() );
        	 // not implemented so far: but can be added to remote uart to
        	 // set the "sink", which takes the UART messages
        	 //remote_uart_.set_sink();
         }
         else if( radio_->id() == 6)
         {
            timer_->set_timer<RemoteUartApplication,
                         &RemoteUartApplication::start>( 1000, this, 0 );
         }
      }
      // --------------------------------------------------------------------
      void start( void* )
      {
         debug_->debug( "sending output to Uart\n" );
         uart_t::block_data_t uart_buf[] = "1234567890\n";
         remote_uart_.write( sizeof (uart_buf), uart_buf );

         timer_->set_timer<RemoteUartApplication,
                  &RemoteUartApplication::start > (1000, this, 0);
      }

   private:
      Os::Radio::self_pointer_t radio_;
      Os::Timer::self_pointer_t timer_;
      Os::Debug::self_pointer_t debug_;
      Os::Rand::self_pointer_t random_;

      remote_uart_t remote_uart_;
      flooding_t flooding_;
      routing_t routing_;

      uart_t::self_pointer_t uart_;
};
// --------------------------------------------------------------------------
wiselib::WiselibApplication<Os, RemoteUartApplication> routing_app;
// --------------------------------------------------------------------------
void application_main( Os::AppMainParameter& value )
{
   routing_app.init( value );
}
