
#include "string.h"

#include "external_interface/external_interface.h"
#include "external_interface/external_interface_testing.h"

typedef wiselib::OSMODEL Os;

class ExampleApplication {
	public:
		void init(Os::AppMainParameter& amp) {
			radio_ = &wiselib::FacetProvider<Os, Os::Radio>::get_facet(amp);
			debug_ = &wiselib::FacetProvider<Os, Os::Debug>::get_facet(amp);
			timer_ = &wiselib::FacetProvider<Os, Os::Timer>::get_facet(amp);
			
			radio_->enable_radio();
			radio_->reg_recv_callback<
				ExampleApplication,
				&ExampleApplication::on_receive
			>(this);
			
			on_time(0);
		}
		
		void on_receive(Os::Radio::node_id_t sender, Os::Radio::size_t size, Os::Radio::block_data_t* data) {
			char s[size + 1];
			memcpy(s, data, size);
			s[size] = '\0';
			debug_->debug("Node %d received from %d\n", radio_->id(), sender);
			//debug_->debug("  %s\n", s);
		}
		
		void on_time(void* userdata) {
			debug_->debug("Node %d broadcasting...\n", radio_->id());

			char *msg = "Hello, World!";
			radio_->send(Os::Radio::BROADCAST_ADDRESS, strlen(msg), (Os::Radio::block_data_t*)msg);
			timer_->set_timer<ExampleApplication, &ExampleApplication::on_time>(2000, this, 0);
		}
		
		
	private:
		Os::Radio::self_pointer_t radio_;
		Os::Debug::self_pointer_t debug_;
		Os::Timer::self_pointer_t timer_;
};

wiselib::WiselibApplication<Os, ExampleApplication> example_app;

void application_main(Os::AppMainParameter& amp) {
	example_app.init(amp);
}

